/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest.area;

import dev.toma.gunsrpg.ai.AlwaysAggroOnGoal;
import dev.toma.gunsrpg.ai.QuestPlayerSensor;
import dev.toma.gunsrpg.common.init.ModSensors;
import dev.toma.gunsrpg.common.quests.quest.area.IMobSpawnProcessor;
import dev.toma.gunsrpg.common.quests.quest.area.IMobSpawner;
import dev.toma.gunsrpg.common.quests.quest.area.IMobTargettingContext;
import dev.toma.gunsrpg.common.quests.quest.area.MobSpawnProcessorType;
import dev.toma.gunsrpg.common.quests.quest.area.QuestArea;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class MobSpawner
implements IMobSpawner {
    private final EntityType<? extends LivingEntity> entityType;
    private final int weight;
    private final int minCount;
    private final int maxCount;
    private final List<IMobSpawnProcessor> processorList;

    public MobSpawner(EntityType<? extends LivingEntity> entityType, int weight, int minCount, int maxCount, List<IMobSpawnProcessor> processorList) {
        this.entityType = entityType;
        this.weight = weight;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.processorList = processorList;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    public static MobSpawner fromNbt(CompoundNBT nbt) {
        ResourceLocation entityId = new ResourceLocation(nbt.func_74779_i("livingEntity"));
        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(entityId);
        int weight = nbt.func_74762_e("weight");
        int minCount = nbt.func_74762_e("minCount");
        int maxCount = nbt.func_74762_e("maxCount");
        ListNBT listNBT = nbt.func_150295_c("processors", 10);
        List<IMobSpawnProcessor> list = listNBT.stream().map(inbt -> MobSpawnProcessorType.fromNbt((CompoundNBT)inbt)).collect(Collectors.toList());
        return new MobSpawner((EntityType<? extends LivingEntity>)entityType, weight, minCount, maxCount, list);
    }

    @Override
    public void spawnMobsRandomly(World world, QuestArea area, PlayerEntity attackTarget) {
        int toSpawn = this.minCount + world.field_73012_v.nextInt(1 + this.maxCount - this.minCount);
        for (int i = 0; i < toSpawn; ++i) {
            this.spawnMob(world, area, attackTarget);
        }
    }

    @Override
    public CompoundNBT toNbt() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("livingEntity", this.entityType.getRegistryName().toString());
        nbt.func_74768_a("weight", this.weight);
        nbt.func_74768_a("minCount", this.minCount);
        nbt.func_74768_a("maxCount", this.maxCount);
        ListNBT list = new ListNBT();
        this.processorList.stream().map(this::serializeProcessor).forEach(arg_0 -> list.add(arg_0));
        nbt.func_218657_a("processors", (INBT)list);
        return nbt;
    }

    private void spawnMob(World world, QuestArea area, PlayerEntity attackTarget) {
        BlockPos pos = area.getRandomEgdePosition(world.field_73012_v, world);
        LivingEntity livingEntity = (LivingEntity)this.entityType.func_200721_a(world);
        livingEntity.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        IMobTargettingContext context = entity -> {
            ServerWorld serverWorld = (ServerWorld)entity.field_70170_p;
            if (entity instanceof MobEntity) {
                MobEntity mob = (MobEntity)entity;
                mob.func_213386_a((IServerWorld)serverWorld, world.func_175649_E(pos), SpawnReason.COMMAND, null, null);
                mob.func_70624_b((LivingEntity)attackTarget);
                AlwaysAggroOnGoal<PlayerEntity> alwaysAggroOnGoal = new AlwaysAggroOnGoal<PlayerEntity>(mob, false, attackTarget);
                mob.field_70715_bh.func_75776_a(0, alwaysAggroOnGoal);
            }
            entity.func_233645_dx_().func_233779_a_(Attributes.field_233819_b_).func_111128_a((double)(area.getScheme().getSize() * 4));
            Brain brain = entity.func_213375_cj();
            brain.func_218205_a(MemoryModuleType.field_234079_M_, (Object)true);
            Map sensors = brain.field_218231_b;
            sensors.remove(SensorType.field_220999_c);
            SensorType<QuestPlayerSensor> sensorType = ModSensors.QUEST_PLAYER_SENSOR;
            QuestPlayerSensor questPlayerSensor = (QuestPlayerSensor)sensorType.func_220995_a();
            questPlayerSensor.setTarget(attackTarget);
            sensors.put(sensorType, questPlayerSensor);
        };
        this.processorList.forEach(processor -> processor.processMobSpawn(livingEntity, context));
        world.func_217376_c((Entity)livingEntity);
        context.processMobSpawn(livingEntity);
    }

    private <P extends IMobSpawnProcessor> CompoundNBT serializeProcessor(P processor) {
        MobSpawnProcessorType<?> type = processor.getType();
        return type.toNbt(processor);
    }
}

